module net.BurtonRadons.spyl.expressionArray;

private import net.BurtonRadons.spyl.expression;
private import net.BurtonRadons.spyl.value;
private import net.BurtonRadons.spyl.valueArray;
private import net.BurtonRadons.spyl.mark;
private import net.BurtonRadons.spyl.scope;

/** Create an array of values; "[a, b, c...]". */
class ArrayExpression : Expression
{
    Expression [] values; /**< Values in the array. */
    
    /** Assign the parameters. */
    this (Mark mark, Expression [] values)
    {
        super (mark);
        this.values = values;
    }
    
    override Value evaluate (Scope scope)
    {
        Value [] result = new Value [values.length];
        
        for (int c; c < result.length; c ++)
            result [c] = values [c].evaluate (scope);
            
        return new ArrayValue (result);
    }
    
    override char [] toString ()
    {
        char [] text;
        
        text = "[";
        for (int c; c < values.length; c ++)
        {
            if (c)
                text ~= ", ";
            text ~= values [c].toString (Precedence.Unary);
        }
        
        return text ~ "]";
    }
    
    override int precedence ()
    {
        return Precedence.Primary;
    }
}